## api

Express API to provision + claim `*.opentill.sol` subdomains with a standard SNS **URL record**.

### Endpoints
- POST `/api/nonce`
- POST `/api/subdomain/create`
- POST `/api/subdomain/claim`

### What happens
- Subdomain is deterministically derived from the NFT mint: `{role}-{mintPrefix}.opentill.sol`
- API verifies:
  1) one-time nonce
  2) wallet signature over the action message
  3) wallet currently owns the NFT mint (standard NFT, supply 1)
- API then:
  - creates the subdomain if missing
  - creates/updates the SNS **URL record** to point to your role path

### Role paths
With `PROFILE_BASE_URL=https://mint.opentill.io`, the URL record will be:
- Ambassador: `https://mint.opentill.io/ambassador/<mint>`
- Merchant: `https://mint.opentill.io/merchant/<mint>`
- Consumer: `https://mint.opentill.io/consumer/<mint>`
