import crypto from 'crypto';
type Action='CREATE'|'CLAIM';
type Entry={nonce:string;action:Action;wallet:string;expiresAt:number;used:boolean;};
class NonceStore{
  private map=new Map<string,Entry>();
  private ttlMs=5*60*1000;
  issue(input:{action:Action;wallet:string}){
    const nonce=crypto.randomBytes(16).toString('hex');
    const expiresAt=Date.now()+this.ttlMs;
    this.map.set(nonce,{nonce,action:input.action,wallet:input.wallet,expiresAt,used:false});
    return {nonce,expiresAt};
  }
  consume(input:{nonce:string;action:Action;wallet:string}){
    const e=this.map.get(input.nonce);
    if(!e) throw new Error('Invalid nonce');
    if(e.used) throw new Error('Nonce already used');
    if(Date.now()>e.expiresAt) throw new Error('Nonce expired');
    if(e.action!==input.action) throw new Error('Nonce action mismatch');
    if(e.wallet!==input.wallet) throw new Error('Nonce wallet mismatch');
    e.used=true;
  }
}
export const nonceStore=new NonceStore();
