import React from 'react';
export function Button(props:React.ButtonHTMLAttributes<HTMLButtonElement>&{variant?:'primary'|'ghost'}){
  const {className='',variant='primary',...rest}=props;
  const base='inline-flex items-center justify-center rounded-xl px-4 py-2 text-sm font-semibold transition disabled:opacity-50 disabled:cursor-not-allowed';
  const styles=variant==='primary'?'bg-zinc-100 text-zinc-900 hover:bg-white':'bg-transparent text-zinc-100 hover:bg-zinc-900 border border-zinc-800';
  return <button className={`${base} ${styles} ${className}`} {...rest}/>;
}
