import 'dotenv/config';
import express from 'express';
import cors from 'cors';
import {routes} from './routes';

const app=express();
const allowed=(process.env.ALLOWED_ORIGINS||'').split(',').map(s=>s.trim()).filter(Boolean);

app.use(cors({
  origin:(origin,cb)=>{
    if(!origin) return cb(null,true);
    if(allowed.length===0) return cb(null,true);
    if(allowed.includes(origin)) return cb(null,true);
    return cb(new Error('CORS blocked'));
  }
}));
app.use(express.json({limit:'1mb'}));

app.get('/health',(_req,res)=>res.json({ok:true}));
app.use('/api', routes);

const port=Number(process.env.PORT||8787);
app.listen(port,()=>console.log(`API listening on :${port}`));
