import {Router} from 'express';
import {z} from 'zod';
import {nonceStore} from '../stores/nonces';
export const nonceRouter=Router();
const Body=z.object({action:z.enum(['CREATE','CLAIM']),wallet:z.string().min(32)});
nonceRouter.post('/',(req,res)=>{
  const p=Body.safeParse(req.body);
  if(!p.success) return res.status(400).send(p.error.message);
  const {nonce,expiresAt}=nonceStore.issue(p.data);
  res.json({nonce,expiresAt});
});
