import nacl from 'tweetnacl';
import {PublicKey} from '@solana/web3.js';
export function verifySignedMessage(params:{wallet:string;message:string;signatureB64:string}){
  const pk=new PublicKey(params.wallet);
  const sig=Buffer.from(params.signatureB64,'base64');
  const msg=Buffer.from(params.message,'utf8');
  const ok=nacl.sign.detached.verify(msg,sig,pk.toBytes());
  if(!ok) throw new Error('Invalid signature');
}
