import React,{useMemo} from 'react';
import {ConnectionProvider,WalletProvider} from '@solana/wallet-adapter-react';
import {WalletModalProvider} from '@solana/wallet-adapter-react-ui';
import {PhantomWalletAdapter,SolflareWalletAdapter} from '@solana/wallet-adapter-wallets';
import {CONFIG} from '../config';
import '@solana/wallet-adapter-react-ui/styles.css';
export function SolanaProviders({children}:{children:React.ReactNode}){
  const wallets=useMemo(()=>[new PhantomWalletAdapter(),new SolflareWalletAdapter()],[]);
  return(
    <ConnectionProvider endpoint={CONFIG.rpcUrl}>
      <WalletProvider wallets={wallets} autoConnect>
        <WalletModalProvider>{children}</WalletModalProvider>
      </WalletProvider>
    </ConnectionProvider>
  );
}
